/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.outline;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.editor.common.outline.CompositeOutlineLabelProvider;
import com.aptana.editor.css.outline.CSSOutlineLabelProvider;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.outline.OutlinePlaceholderItem;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLNode;
import com.aptana.editor.html.parsing.ast.HTMLTextNode;
import com.aptana.editor.js.outline.JSOutlineLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class HTMLOutlineLabelProvider
extends CompositeOutlineLabelProvider {
    private static final Image ELEMENT_ICON = HTMLPlugin.getImage("icons/element.png");

    public HTMLOutlineLabelProvider() {
        this.addSubLanguage("com.aptana.contenttype.css", (ILabelProvider)new CSSOutlineLabelProvider());
        this.addSubLanguage("com.aptana.contenttype.js", (ILabelProvider)new JSOutlineLabelProvider());
    }

    protected Image getDefaultImage(Object element) {
        if (element instanceof CommonOutlineItem) {
            return this.getDefaultImage(((CommonOutlineItem)element).getReferenceNode());
        }
        if (element instanceof OutlinePlaceholderItem) {
            OutlinePlaceholderItem item = (OutlinePlaceholderItem)element;
            if (item.status() == 4) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            if (item.status() == 1) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        }
        if (element instanceof HTMLNode) {
            return ELEMENT_ICON;
        }
        return super.getDefaultImage(element);
    }

    protected String getDefaultText(Object element) {
        if (element instanceof CommonOutlineItem) {
            return this.getDefaultText(((CommonOutlineItem)element).getReferenceNode());
        }
        if (element instanceof HTMLElementNode) {
            return ((HTMLElementNode)element).getText();
        }
        if (element instanceof HTMLTextNode) {
            String text = ((HTMLTextNode)element).getText().trim();
            return StringUtil.truncate((String)text, (int)20);
        }
        return super.getDefaultText(element);
    }
}

